<?php

/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */

/*
 * Created on 04. Aug. 2007 by Norman Markgraf (nmarkgraf(at)user.sourceforge.net)
 */

/**
 * OpenDocumentCalc load test file.
 * 
 * PHP versions 5
 *   
 * LICENSE:
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * This software consists of voluntary contributions made by many individuals
 * and is licensed under the GPL. For more information please see
 * <http://opendocumentphp.org>.
 * 
 * $Id: OpenDocumentCalcLoadTest.php 264 2007-08-06 08:29:08Z nmarkgraf $
 * 
 * @category    File Formats
 * @package     OpenDocumentPHP
 * @subpackage  test
 * @author      Norman Markgraf (nmarkgraf(at)user.sourceforge.net)
 * @copyright   Copyright in 2006, 2007 by The OpenDocumentPHP Team 
 * @license     http://www.gnu.org/licenses/gpl.html GNU General Public License 2.0.
 * @version     SVN: $Id: OpenDocumentCalcLoadTest.php 264 2007-08-06 08:29:08Z nmarkgraf $
 * @link        http://opendocumentphp.org
 * @since       0.5.3 - 04. Aug. 2007
 */

/*
 * Call OpenDocumentCalcLoadTest::main() if this source file is executed directly.  
 */
if (!defined("PHPUnit_MAIN_METHOD")) {
    define("PHPUnit_MAIN_METHOD", "OpenDocumentCalcLoadTest::main");
}


/**
 * 
 */
require_once "PHPUnit/Framework/TestCase.php";
require_once "PHPUnit/Framework/TestSuite.php";
require_once "PHPUnit/TextUI/TestRunner.php";

/**
 * 
 */
require_once 'OpenDocumentPHP/OpenDocumentSpreadsheet.php';

/**
 * Test class for OpenDocumentText. We create a simple document in this unit test check
 * the file size, re-open it and check the file size again.
 *   
 * @category    File Formats
 * @package     OpenDocumentPHP
 * @subpackage  test
 * @author      Norman Markgraf (nmarkgraf(at)user.sourceforge.net)
 * @copyright   Copyright in 2006, 2007 by The OpenDocumentPHP Team 
 * @license     http://www.gnu.org/licenses/gpl.html GNU General Public License 2.0.
 * @version     Release: @package_version@
 * @link        http://opendocumentphp.org
 * @since       0.5.3 - 04. Aug. 2007
 */
class OpenDocumentCalcLoadTest extends PHPUnit_Framework_TestCase 
{
    
    private $filesize;

    /**
     * Runs the test methods of this class.
     *
     * @access      public
     * @static
     * @since       0.5.3 - 04. Aug. 2007
     */
    public static function main() 
    {
        $result = PHPUnit_TextUI_TestRunner :: run(self::suite());
    }
    
    /**
     * Runs the test methods of this class.
     *
     * @access public
     * @static
     * @since       0.5.3 - 04. Aug. 2007
     */
    public static function suite() 
    {
        $suite = new PHPUnit_Framework_TestSuite("basic tests");
        $suite->addTestSuite('OpenDocumentCalcLoadTest');
        return $suite;
    }
                
    /**
     * We create a little OpenDocumentSpreadsheet file first in this setup routine.
     *
     * @access      protected
     * @since       0.5.3 - 04. Aug. 2007
     */
    protected function setUp() 
    {
    
        $this->filename = 'unittest.odc';
        
        /*
         * If the temporary file does still exists, remove it.
         */
        if ( file_exists( $this->filename ) ) {
            unlink( $this->filename );
        }               
        /*
         * Create a simple document
         */
        $doc = new OpenDocumentSpreadsheet($this->filename);
        $doc->setDefaultMeta();
        $doc->setDefaultFontFaces();
        $doc->setDefaultStyles();
        $calc = $doc->getBody()->getSpreadsheetFragment();
        /* *** FIX ME *** 
        $heading = $text->nextHeading();
        $heading->setStyleName('Heading_20_1');
        $heading->append('Headline');
        $paragraph = $text->nextParagraph();
        $paragraph->setStyleName('Standard');
        $paragraph->append('The first paragraph in the document. ');
        $paragraph->append('And this is the 2nd part of this first paragraph.');
        */
        $doc->close();

        $this->filesize = filesize($this->filename);
    }
    
    /**
     * Tears down the fixture, for example, close a network connection.
     * This method is called after a test is executed.
     *
     * @access      protected
     * @since       0.5.3 - 01. Aug. 2007
     */
    protected function tearDown() 
    {
        // If the temporary file does still exists, remove it.
        if ( file_exists( $this->filename ) ) {
            unlink( $this->filename );
        }               
    }
    
    /**
     * Simply load the test document and close it again. This should produce no difference 
     * in file size.
     * 
     * @access      public
     * @since       0.5.3 - 01. Aug. 2007
     */
    function testLoadExistingAgain() 
    {
        /*
         * Try to load an existing file
         */
        $doc = new OpenDocumentSpreadsheet( $this->filename );
        /*
         * and close it again.
         */
        $doc->close();
        // And now run the tests...
        $this->assertEquals(filesize($this->filename), $this->filesize, 'Filesize should not be different.' );
    }
    
}

if (PHPUnit_MAIN_METHOD == "OpenDocumentCalcLoadTest::main") {
    OpenDocumentCalcLoadTest::main();
}

?>